ORCA/M Asm65816 2.1.0

0001 FBD9                       title 'COMMON       GS ROM 3.0'
0002 FBD9              ****************************************************************
0003 FBD9              *                                                              *
0004 FBD9              *              Common                                          *
0005 FBD9              *                                                              *
0006 FBD9              ****************************************************************
0007 FBD9
0008 FBD9
0009 FBD9              ****************************************************************
0010 FBD9              *                                                              *
0011 FBD9              *                   Copyright (C) 1985-1988                    *
0012 FBD9              *                   All Rights Reserved                        *
0013 FBD9              *                   Apple Computer, Inc.                       *
0014 FBD9              *                                                              *
0015 FBD9              ****************************************************************
0016 FBD9
0017 FBD9              **********************************************************************
0018 FBD9              *
0019 FBD9              * Change History
0020 FBD9              *
0021 FBD9              * 10 Jun 88         Steven Glass
0022 FBD9              *
0023 FBD9              * This file contains the strip code again.
0024 FBD9              *
0025 FBD9              * The 0-strip routines do not fall through the common code but rather
0026 FBD9              * short cut the process saving cycles.  This should get the 
0027 FBD9              * UCSD Pascal working again.
0028 FBD9              *
0029 FBD9              **********************************************************************
0030 FBD9
0031 FBD9                       include '::sys.equs.asm' 
0032 FBD9
0033 FBD9              ;-----------------------------------------------
0034 FBD9              ;
0035 FBD9              ;   Forward addresses and entries
0036 FBD9              ;
0037 FBD9              ;-----------------------------------------------
0038 FBD9
0039 FBD9                       ENTRY ErrOut 
0040 FBD9                       ENTRY oBusyErr 
0041 FBD9                       ENTRY oErrOut 
0042 FBD9                       ENTRY oErrOut0 
0043 FBD9
0044 FBD9              ****************************************************************
0045 FBD9              *
0046 FBD9              * NotImp
0047 FBD9              *
0048 FBD9              ****************************************************************
0049 FBD9                       EXPORT NotImp
0050 FBD9              NotImp   PROC 
0051 FBD9
0052 FBD9 A2 FF FF              ldx   #$FFFF
0053 FBDC 4C E4 FB              jmp   oErrOut0
0054 FBDF
0055 FBDF                       ENDP 
0056 FBDF
0057 FBDF
0058 FBDF              ****************************************************************
0059 FBDF              *
0060 FBDF              * EndCall Routines.
0061 FBDF              *
0062 FBDF              * Functions exit through the EndCall routines.  These routines
0063 FBDF              * fix the stack by moving the RTL addresses up and stripping
0064 FBDF              * off any input parameters.
0065 FBDF              *
0066 FBDF              * The number of bytes to strip off the stack is passed in the
0067 FBDF              * y-register.
0068 FBDF              *
0069 FBDF              * There are 8 end call routines
0070 FBDF              *
0071 FBDF              *       EndCall        Pulls D off stack before cleaning up.  Sets
0072 FBDF              *                      a-reg to zero and clears carry.
0073 FBDF              *       oEndCall       Does not pull D off the stack before
0074 FBDF              *                      cleaning up.  Sets a-reg to zero and clears
0075 FBDF              *                      carry.
0076 FBDF              *       ErrOut         Pulls D off stack, cleans up and returns
0077 FBDF              *                      error code passed in x-register, setting
0078 FBDF              *                      carry if x is not zero.
0079 FBDF              *       oErrOut        Does not pull D off stack before cleaning up.
0080 FBDF              *                      returns error code passed in x-register,
0081 FBDF              *                      setting carry if x is not zero.
0082 FBDF              *
0083 FBDF              *       BusyEC         Decrements the busy flag, pulls D off stack
0084 FBDF              *                      and cleans up.
0085 FBDF              *       oBusyEC        Decrements the busy flag, does not pull D off stack
0086 FBDF              *                      and cleans up.
0087 FBDF              *       BusyErr        Decrements the busy flag, pulls D off stack,
0088 FBDF              *                      cleans up and returns error code passed in
0089 FBDF              *                      x-register, setting the carry if x is not zero.
0090 FBDF              *       oBusyErr       Decrements the busy flag, does not pull D off
0091 FBDF              *                      the stack, cleans up and returns error code passed
0092 FBDF              *                      in x-register.
0093 FBDF              *
0094 FBDF              ****************************************************************
0095 FBDF
0096 FBDF
0097 FBDF
0098 FBDF                       EXPORT oEndCall0
0099 FBDF              oEndCall0 PROC 
0100 FBDF 0B                    phd   
0101 FBE0                       EXPORT EndCall0
0102 FBE0              EndCall0                                ; 
0103 FBE0 A2 00 00              ldx   #0
0104 FBE3                       EXPORT ErrOut0
0105 FBE3              ErrOut0                                 ; 
0106 FBE3 2B                    pld   
0107 FBE4                       EXPORT oErrOut0
0108 FBE4              oErrOut0                                ; 
0109 FBE4 8A                    txa   
0110 FBE5 C9 01 00              cmp   #1
0111 FBE8 6B                    rtl   
0112 FBE9                       ENDP 
0113 FBE9
0114 FBE9                       EXPORT oBusyEC0
0115 FBE9              oBusyEC0 PROC 
0116 FBE9 0B                    phd   
0117 FBEA                       EXPORT BusyEC0
0118 FBEA              BusyEC0                                 ; 
0119 FBEA A2 00 00              ldx   #0
0120 FBED                       EXPORT BusyErr0
0121 FBED              BusyErr0                                ; 
0122 FBED 2B                    pld   
0123 FBEE                       EXPORT oBusyErr0
0124 FBEE              oBusyErr0                               ; 
0125 FBEE 8A                    txa   
0126 FBEF C9 01 00              cmp   #1
0127 FBF2 22 68 00 E1           jsl   DecBusyFlg
0128 FBF6 6B                    rtl   
0129 FBF7                       ENDP 
0130 FBF7
0131 FBF7
0132 FBF7                       EXPORT oEndCall2
0133 FBF7              oEndCall2 PROC 
0134 FBF7 0B                    phd   
0135 FBF8                       EXPORT EndCall2
0136 FBF8              EndCall2                                ; 
0137 FBF8 A2 00 00              ldx   #0
0138 FBFB                       EXPORT ErrOut2
0139 FBFB              ErrOut2                                 ; 
0140 FBFB 2B                    pld   
0141 FBFC                       EXPORT oErrOut2
0142 FBFC              oErrOut2                                ; 
0143 FBFC A0 02 00              ldy   #2
0144 FBFF 4C B4 FC              jmp   oErrOut
0145 FC02                       ENDP 
0146 FC02
0147 FC02                       EXPORT oBusyEC2
0148 FC02              oBusyEC2 PROC 
0149 FC02 0B                    phd   
0150 FC03                       EXPORT BusyEC2
0151 FC03              BusyEC2                                 ; 
0152 FC03 A2 00 00              ldx   #0
0153 FC06                       EXPORT BusyErr2
0154 FC06              BusyErr2                                ; 
0155 FC06 2B                    pld   
0156 FC07                       EXPORT oBusyErr2
0157 FC07              oBusyErr2                               ; 
0158 FC07 A0 02 00              ldy   #2
0159 FC0A 4C E7 FC              jmp   oBusyErr
0160 FC0D                       ENDP 
0161 FC0D
0162 FC0D                       EXPORT oEndCall4
0163 FC0D              oEndCall4 PROC 
0164 FC0D 0B                    phd   
0165 FC0E                       EXPORT EndCall4
0166 FC0E              EndCall4                                ; 
0167 FC0E A2 00 00              ldx   #0
0168 FC11                       EXPORT ErrOut4
0169 FC11              ErrOut4                                 ; 
0170 FC11 2B                    pld   
0171 FC12                       EXPORT oErrOut4
0172 FC12              oErrOut4                                ; 
0173 FC12 A0 04 00              ldy   #4
0174 FC15 4C B4 FC              jmp   oErrOut
0175 FC18                       ENDP 
0176 FC18
0177 FC18                       EXPORT oBusyEC4
0178 FC18              oBusyEC4 PROC 
0179 FC18 0B                    phd   
0180 FC19                       EXPORT BusyEC4
0181 FC19              BusyEC4                                 ; 
0182 FC19 A2 00 00              ldx   #0
0183 FC1C                       EXPORT BusyErr4
0184 FC1C              BusyErr4                                ; 
0185 FC1C 2B                    pld   
0186 FC1D                       EXPORT oBusyErr4
0187 FC1D              oBusyErr4                               ; 
0188 FC1D A0 04 00              ldy   #4
0189 FC20 4C E7 FC              jmp   oBusyErr
0190 FC23                       ENDP 
0191 FC23
0192 FC23                       EXPORT oEndCall6
0193 FC23              oEndCall6 PROC 
0194 FC23 0B                    phd   
0195 FC24                       EXPORT EndCall6
0196 FC24              EndCall6                                ; 
0197 FC24 A2 00 00              ldx   #0
0198 FC27                       EXPORT ErrOut6
0199 FC27              ErrOut6                                 ; 
0200 FC27 2B                    pld   
0201 FC28                       EXPORT oErrOut6
0202 FC28              oErrOut6                                ; 
0203 FC28 A0 06 00              ldy   #6
0204 FC2B 4C B4 FC              jmp   oErrOut
0205 FC2E                       ENDP 
0206 FC2E
0207 FC2E                       EXPORT oBusyEC6
0208 FC2E              oBusyEC6 PROC 
0209 FC2E 0B                    phd   
0210 FC2F                       EXPORT BusyEC6
0211 FC2F              BusyEC6                                 ; 
0212 FC2F A2 00 00              ldx   #0
0213 FC32                       EXPORT BusyErr6
0214 FC32              BusyErr6                                ; 
0215 FC32 2B                    pld   
0216 FC33                       EXPORT oBusyErr6
0217 FC33              oBusyErr6                               ; 
0218 FC33 A0 06 00              ldy   #6
0219 FC36 4C E7 FC              jmp   oBusyErr
0220 FC39                       ENDP 
0221 FC39
0222 FC39                       EXPORT oEndCall8
0223 FC39              oEndCall8 PROC 
0224 FC39 0B                    phd   
0225 FC3A                       EXPORT EndCall8
0226 FC3A              EndCall8                                ; 
0227 FC3A A2 00 00              ldx   #0
0228 FC3D                       EXPORT ErrOut8
0229 FC3D              ErrOut8                                 ; 
0230 FC3D 2B                    pld   
0231 FC3E                       EXPORT oErrOut8
0232 FC3E              oErrOut8                                ; 
0233 FC3E A0 08 00              ldy   #8
0234 FC41 4C B4 FC              jmp   oErrOut
0235 FC44                       ENDP 
0236 FC44
0237 FC44                       EXPORT oBusyEC8
0238 FC44              oBusyEC8 PROC 
0239 FC44 0B                    phd   
0240 FC45                       EXPORT BusyEC8
0241 FC45              BusyEC8                                 ; 
0242 FC45 A2 00 00              ldx   #0
0243 FC48                       EXPORT BusyErr8
0244 FC48              BusyErr8                                ; 
0245 FC48 2B                    pld   
0246 FC49                       EXPORT oBusyErr8
0247 FC49              oBusyErr8                               ; 
0248 FC49 A0 08 00              ldy   #8
0249 FC4C 4C E7 FC              jmp   oBusyErr
0250 FC4F                       ENDP 
0251 FC4F
0252 FC4F                       EXPORT oEndCall10
0253 FC4F              oEndCall10 PROC 
0254 FC4F 0B                    phd   
0255 FC50                       EXPORT EndCall10
0256 FC50              EndCall10                               ; 
0257 FC50 A2 00 00              ldx   #0
0258 FC53                       EXPORT ErrOut10
0259 FC53              ErrOut10                                ; 
0260 FC53 2B                    pld   
0261 FC54                       EXPORT oErrOut10
0262 FC54              oErrOut10                               ; 
0263 FC54 A0 0A 00              ldy   #10
0264 FC57 4C B4 FC              jmp   oErrOut
0265 FC5A                       ENDP 
0266 FC5A
0267 FC5A                       EXPORT oBusyEC10
0268 FC5A              oBusyEC10 PROC 
0269 FC5A 0B                    phd   
0270 FC5B                       EXPORT BusyEC10
0271 FC5B              BusyEC10                                ; 
0272 FC5B A2 00 00              ldx   #0
0273 FC5E                       EXPORT BusyErr10
0274 FC5E              BusyErr10                               ; 
0275 FC5E 2B                    pld   
0276 FC5F                       EXPORT oBusyErr10
0277 FC5F              oBusyErr10                              ; 
0278 FC5F A0 0A 00              ldy   #10
0279 FC62 4C E7 FC              jmp   oBusyErr
0280 FC65                       ENDP 
0281 FC65
0282 FC65                       EXPORT oEndCall12
0283 FC65              oEndCall12 PROC 
0284 FC65 0B                    phd   
0285 FC66                       EXPORT EndCall12
0286 FC66              EndCall12                               ; 
0287 FC66 A2 00 00              ldx   #0
0288 FC69                       EXPORT ErrOut12
0289 FC69              ErrOut12                                ; 
0290 FC69 2B                    pld   
0291 FC6A                       EXPORT oErrOut12
0292 FC6A              oErrOut12                               ; 
0293 FC6A A0 0C 00              ldy   #12
0294 FC6D 4C B4 FC              jmp   oErrOut
0295 FC70                       ENDP 
0296 FC70
0297 FC70                       EXPORT oBusyEC12
0298 FC70              oBusyEC12 PROC 
0299 FC70 0B                    phd   
0300 FC71                       EXPORT BusyEC12
0301 FC71              BusyEC12                                ; 
0302 FC71 A2 00 00              ldx   #0
0303 FC74                       EXPORT BusyErr12
0304 FC74              BusyErr12                               ; 
0305 FC74 2B                    pld   
0306 FC75                       EXPORT oBusyErr12
0307 FC75              oBusyErr12                              ; 
0308 FC75 A0 0C 00              ldy   #12
0309 FC78 4C E7 FC              jmp   oBusyErr
0310 FC7B                       ENDP 
0311 FC7B
0312 FC7B                       EXPORT oEndCall14
0313 FC7B              oEndCall14 PROC 
0314 FC7B 0B                    phd   
0315 FC7C                       EXPORT EndCall14
0316 FC7C              EndCall14                               ; 
0317 FC7C A2 00 00              ldx   #0
0318 FC7F                       EXPORT ErrOut14
0319 FC7F              ErrOut14                                ; 
0320 FC7F 2B                    pld   
0321 FC80                       EXPORT oErrOut14
0322 FC80              oErrOut14                               ; 
0323 FC80 A0 0E 00              ldy   #14
0324 FC83 4C B4 FC              jmp   oErrOut
0325 FC86                       ENDP 
0326 FC86
0327 FC86                       EXPORT oBusyEC14
0328 FC86              oBusyEC14 PROC 
0329 FC86 0B                    phd   
0330 FC87                       EXPORT BusyEC14
0331 FC87              BusyEC14                                ; 
0332 FC87 A2 00 00              ldx   #0
0333 FC8A                       EXPORT BusyErr14
0334 FC8A              BusyErr14                               ; 
0335 FC8A 2B                    pld   
0336 FC8B                       EXPORT oBusyErr14
0337 FC8B              oBusyErr14                              ; 
0338 FC8B A0 0E 00              ldy   #14
0339 FC8E 4C E7 FC              jmp   oBusyErr
0340 FC91                       ENDP 
0341 FC91
0342 FC91                       EXPORT oEndCall16
0343 FC91              oEndCall16 PROC 
0344 FC91 0B                    phd   
0345 FC92                       EXPORT EndCall16
0346 FC92              EndCall16                               ; 
0347 FC92 A2 00 00              ldx   #0
0348 FC95                       EXPORT ErrOut16
0349 FC95              ErrOut16                                ; 
0350 FC95 2B                    pld   
0351 FC96                       EXPORT oErrOut16
0352 FC96              oErrOut16                               ; 
0353 FC96 A0 10 00              ldy   #16
0354 FC99 4C B4 FC              jmp   oErrOut
0355 FC9C                       ENDP 
0356 FC9C
0357 FC9C                       EXPORT oBusyEC16
0358 FC9C              oBusyEC16 PROC 
0359 FC9C 0B                    phd   
0360 FC9D                       EXPORT BusyEC16
0361 FC9D              BusyEC16                                ; 
0362 FC9D A2 00 00              ldx   #0
0363 FCA0                       EXPORT BusyErr16
0364 FCA0              BusyErr16                               ; 
0365 FCA0 2B                    pld   
0366 FCA1                       EXPORT oBusyErr16
0367 FCA1              oBusyErr16                              ; 
0368 FCA1 A0 10 00              ldy   #16
0369 FCA4 4C E7 FC              jmp   oBusyErr
0370 FCA7                       ENDP 
0371 FCA7
0372 FCA7
0373 FCA7
0374 FCA7
0375 FCA7
0376 FCA7                       EXPORT Strip
0377 FCA7              Strip    PROC 
0378 FCA7
0379 FCA7                       EXPORT BusyEC
0380 FCA7              BusyEC                                  ; 
0381 FCA7 A2 00 00              ldx   #0
0382 FCAA
0383 FCAA                       EXPORT BusyErr
0384 FCAA              BusyErr                                 ; 
0385 FCAA 22 68 00 E1           jsl   DecBusyFlg
0386 FCAE 80 03                 bra   ErrOut
0387 FCB0
0388 FCB0                       EXPORT EndCall
0389 FCB0              EndCall                                 ; 
0390 FCB0 A2 00 00              ldx   #0
0391 FCB3
0392 FCB3                       EXPORT ErrOut
0393 FCB3              ErrOut                                  ; 
0394 FCB3 2B                    pld                            ; restore direct register
0395 FCB4
0396 FCB4
0397 FCB4                       EXPORT oErrOut
0398 FCB4              oErrOut          
0399 FCB4 5A                    phy                            ; save amount to strip on stack
0400 FCB5 3B                    tsc                            ; get stack pointer
0401 FCB6 18                    clc                            ; add to it the amount to strip
0402 FCB7 63 01                 adc   1,s
0403 FCB9 A8                    tay                            ; put this result in Y
0404 FCBA 3B                    tsc                            ; get back orig stack pointer
0405 FCBB DA                    phx                            ; save error on stack
0406 FCBC AA                    tax                            ; put orig stack in X
0407 FCBD 8B                    phb                            ; now save the data bank reg
0408 FCBE F4 00 00              pea   $0000                    ; set data bank reg to 0
0409 FCC1 AB                    plb   
0410 FCC2 AB                    plb   
0411 FCC3 BD 07 00              lda   |3+4,x                   ;now use x and y to move 6 bytes
0412 FCC6 99 07 00              sta   |3+4,y                   ; of rtl info from current pos
0413 FCC9 BD 05 00              lda   |3+2,x                   ; to final pos.
0414 FCCC 99 05 00              sta   |3+2,y
0415 FCCF BD 03 00              lda   |3+0,x
0416 FCD2 99 03 00              sta   |3+0,y
0417 FCD5 AB                    plb                            ; restore data bank register
0418 FCD6 FA                    plx                            ; restore x register with error
0419 FCD7
0420 FCD7 3B                    tsc                            ; get stack again
0421 FCD8 18                    clc                            ; bump it by amount to strip Plus 2
0422 FCD9 63 01                 adc   1,s                      ; to make up for amount to strip
0423 FCDB 69 02 00              adc   #2                       ; still on stack
0424 FCDE 1B                    tcs                            ; reset stack pointer
0425 FCDF 8A                    txa                            ; error into a-reg
0426 FCE0 C9 01 00              cmp   #1                       ; set carry correctly
0427 FCE3 6B                    rtl                            ; fini
0428 FCE4
0429 FCE4
0430 FCE4
0431 FCE4
0432 FCE4                       EXPORT oBusyEC
0433 FCE4              oBusyEC                                 ; 
0434 FCE4 A2 00 00              ldx   #0
0435 FCE7
0436 FCE7                       EXPORT oBusyErr
0437 FCE7              oBusyErr                                ; 
0438 FCE7 22 68 00 E1           jsl   DecBusyFlg
0439 FCEB 80 C7                 bra   oErrOut
0440 FCED
0441 FCED                       EXPORT oEndCall
0442 FCED              oEndCall                                ; 
0443 FCED A2 00 00              ldx   #0
0444 FCF0 80 C2                 bra   oErrOut
0445 FCF2
0446 FCF2                       ENDP 
0447 FCF2
0448 FCF2
0449 FCF2                       END   
